/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.javaws.ConfigProperties;
import com.sun.javaws.LocalApplicationProperties;
import com.sun.javaws.Resources;
import com.sun.javaws.cache.DiskCacheEntry;
import com.sun.javaws.cache.DownloadProtocol;
import com.sun.javaws.cache.InstallCache;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.exceptions.ErrorCodeResponseException;
import com.sun.javaws.exceptions.FailedDownloadingResourceException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.exceptions.LaunchDescException;
import com.sun.javaws.exceptions.MissingFieldException;
import com.sun.javaws.exceptions.MultipleHostsException;
import com.sun.javaws.exceptions.NativeLibViolationException;
import com.sun.javaws.exceptions.UnsignedAccessViolationException;
import com.sun.javaws.jnl.AppletDesc;
import com.sun.javaws.jnl.ApplicationDesc;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.InstallerDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.PackageDesc;
import com.sun.javaws.jnl.PropertyDesc;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.security.AppPolicy;
import com.sun.javaws.security.SigningInfo;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class LaunchDownload {
    private static final String SIGNED_JNLP_ENTRY = "JNLP-INF/APPLICATION.JNLP";

    public static long getCachedSize(LaunchDesc launchDesc) {
        long l = 0L;
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return l;
        }
        JARDesc[] jARDescArray = resourcesDesc.getEagerOrAllJarDescs(true);
        for (int i = 0; i < jARDescArray.length; ++i) {
            boolean bl = jARDescArray[i].isNativeLib();
            l += DownloadProtocol.getCachedSize(jARDescArray[i].getLocation(), jARDescArray[i].getVersion(), 0);
        }
        return l;
    }

    static void checkJNLPSecurity(LaunchDesc launchDesc) throws MultipleHostsException, NativeLibViolationException {
        boolean[] blArray = new boolean[1];
        boolean[] blArray2 = new boolean[1];
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        JARDesc jARDesc = launchDesc.getResources().getMainJar(true);
        if (jARDesc == null) {
            return;
        }
        LaunchDownload.checkJNLPSecurityHelper(launchDesc, jARDesc.getLocation().getHost(), blArray2, blArray);
        if (blArray2[0]) {
            throw new MultipleHostsException();
        }
        if (blArray[0]) {
            throw new NativeLibViolationException();
        }
    }

    static void checkSignedLaunchDesc(LaunchDesc launchDesc) throws IOException, JNLPException {
        ArrayList arrayList = new ArrayList();
        LaunchDownload.addExtensions(arrayList, launchDesc);
        for (int i = 0; i < arrayList.size(); ++i) {
            LaunchDesc launchDesc2 = (LaunchDesc)arrayList.get(i);
            LaunchDownload.checkSignedLaunchDescHelper(launchDesc2);
        }
    }

    private static void checkSignedLaunchDescHelper(LaunchDesc launchDesc) throws IOException, JNLPException {
        boolean bl = launchDesc.isApplicationDescriptor();
        byte[] byArray = null;
        try {
            byArray = LaunchDownload.getSignedJNLPFile(launchDesc, bl);
            if (byArray != null) {
                LaunchDesc launchDesc2 = LaunchDescFactory.buildDescriptor(byArray);
                if (Globals.TraceStartup) {
                    Debug.println("Signed JNLP file: ");
                    Debug.println(launchDesc2.toString());
                }
                launchDesc.checkSigning(launchDesc2);
                byArray = null;
            }
        }
        catch (LaunchDescException launchDescException) {
            launchDescException.setIsSignedLaunchDesc();
            throw launchDescException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (JNLPException jNLPException) {
            throw jNLPException;
        }
    }

    static void checkSignedResources(LaunchDesc launchDesc) throws IOException, JNLPException {
        ArrayList arrayList = new ArrayList();
        LaunchDownload.addExtensions(arrayList, launchDesc);
        for (int i = 0; i < arrayList.size(); ++i) {
            LaunchDesc launchDesc2 = (LaunchDesc)arrayList.get(i);
            LaunchDownload.checkSignedResourcesHelper(launchDesc2);
        }
    }

    private static void checkSignedResourcesHelper(LaunchDesc launchDesc) throws IOException, JNLPException {
        Object object;
        int n;
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        JARDesc[] jARDescArray = resourcesDesc.getLocalJarDescs();
        boolean bl = true;
        Certificate[] certificateArray = null;
        int n2 = 0;
        URL uRL = null;
        for (n = 0; n < jARDescArray.length; ++n) {
            object = jARDescArray[n];
            int n3 = ((JARDesc)object).isJavaFile() ? 0 : 1;
            DiskCacheEntry diskCacheEntry = DownloadProtocol.getCachedVersion(((JARDesc)object).getLocation(), ((JARDesc)object).getVersion(), n3);
            if (diskCacheEntry == null) continue;
            ++n2;
            Certificate[] certificateArray2 = diskCacheEntry.getCertificateChain();
            if (certificateArray2 == null) {
                bl = false;
                uRL = ((JARDesc)object).getLocation();
            }
            if (certificateArray == null) {
                certificateArray = certificateArray2;
                continue;
            }
            if (certificateArray2 == null || SigningInfo.equalChains(certificateArray, certificateArray2)) continue;
            throw new LaunchDescException(launchDesc, Resources.getString("launch.error.singlecertviolation"), null);
        }
        int n4 = n = launchDesc.getSecurityModel() != 0 ? 1 : 0;
        if (n != 0) {
            if (!bl) {
                throw new UnsignedAccessViolationException(launchDesc, uRL, true);
            }
            if (n2 > 0) {
                object = AppPolicy.getInstance();
                ((AppPolicy)object).grantUnrestrictedAccess(launchDesc, launchDesc.getCanonicalHome(), certificateArray);
            }
        }
    }

    private static boolean getCachedExtensions(LaunchDesc launchDesc) throws IOException, JNLPException {
        return LaunchDownload.downloadExtensionsHelper(launchDesc, null, 0, true, null);
    }

    public static boolean isInCache(LaunchDesc launchDesc) {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return true;
        }
        try {
            DiskCacheEntry diskCacheEntry;
            if (launchDesc.getLocation() != null && (diskCacheEntry = DownloadProtocol.getCachedLaunchedFile(launchDesc.getLocation())) == null) {
                return false;
            }
            boolean bl = LaunchDownload.getCachedExtensions(launchDesc);
            if (!bl) {
                return false;
            }
            JARDesc[] jARDescArray = resourcesDesc.getEagerOrAllJarDescs(false);
            for (int i = 0; i < jARDescArray.length; ++i) {
                int n;
                int n2 = n = jARDescArray[i].isJavaFile() ? 0 : 1;
                if (DownloadProtocol.isInCache(jARDescArray[i].getLocation(), jARDescArray[i].getVersion(), n)) continue;
                return false;
            }
        }
        catch (JNLPException jNLPException) {
            Debug.ignoredException(jNLPException);
            return false;
        }
        catch (IOException iOException) {
            Debug.ignoredException(iOException);
            return false;
        }
        return true;
    }

    public static boolean isUpdateAvailable(LaunchDesc launchDesc) throws JNLPException {
        Object object;
        boolean bl;
        URL uRL = launchDesc.getLocation();
        if (uRL != null && (bl = DownloadProtocol.isLaunchFileUpdateAvailable(uRL))) {
            return true;
        }
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return false;
        }
        ExtensionDesc[] extensionDescArray = resourcesDesc.getExtensionDescs();
        for (int i = 0; i < extensionDescArray.length; ++i) {
            boolean bl2;
            URL uRL2 = extensionDescArray[i].getLocation();
            if (uRL2 == null || !(bl2 = DownloadProtocol.isUpdateAvailable(uRL2, extensionDescArray[i].getVersion(), 4))) continue;
            return true;
        }
        JARDesc[] jARDescArray = resourcesDesc.getEagerOrAllJarDescs(true);
        for (int i = 0; i < jARDescArray.length; ++i) {
            int n;
            URL uRL3 = jARDescArray[i].getLocation();
            object = jARDescArray[i].getVersion();
            int n2 = n = jARDescArray[i].isJavaFile() ? 0 : 1;
            if (!DownloadProtocol.isInCache(uRL3, (String)object, n) || !DownloadProtocol.isUpdateAvailable(uRL3, (String)object, n)) continue;
            return true;
        }
        IconDesc[] iconDescArray = launchDesc.getInformation().getIcons();
        if (iconDescArray != null) {
            for (int i = 0; i < iconDescArray.length; ++i) {
                int n;
                String string;
                object = iconDescArray[i].getLocation();
                if (!DownloadProtocol.isInCache((URL)object, string = iconDescArray[i].getVersion(), n = 2) || !DownloadProtocol.isUpdateAvailable((URL)object, string, n)) continue;
                return true;
            }
        }
        return false;
    }

    private static byte[] getSignedJNLPFile(LaunchDesc launchDesc, boolean bl) throws IOException, JNLPException {
        Object object;
        Object object2;
        if (launchDesc.getResources() == null) {
            return null;
        }
        JARDesc jARDesc = launchDesc.getResources().getMainJar(bl);
        if (jARDesc == null) {
            return null;
        }
        DiskCacheEntry diskCacheEntry = DownloadProtocol.getResource(jARDesc.getLocation(), jARDesc.getVersion(), 0, true, null);
        JarFile jarFile = new JarFile(diskCacheEntry.getFile());
        Object object3 = jarFile.getJarEntry(SIGNED_JNLP_ENTRY);
        if (object3 == null) {
            object2 = jarFile.entries();
            while (object2.hasMoreElements() && object3 == null) {
                object = (JarEntry)object2.nextElement();
                if (!((ZipEntry)object).getName().equalsIgnoreCase(SIGNED_JNLP_ENTRY)) continue;
                object3 = object;
            }
        }
        if (object3 == null) {
            if (jarFile != null) {
                jarFile.close();
            }
            return null;
        }
        object2 = new byte[(int)((ZipEntry)object3).getSize()];
        object = new DataInputStream(jarFile.getInputStream((ZipEntry)object3));
        ((DataInputStream)object).readFully((byte[])object2, 0, (int)((ZipEntry)object3).getSize());
        ((FilterInputStream)object).close();
        jarFile.close();
        return object2;
    }

    private static void downloadJarFiles(JARDesc[] jARDescArray, DownloadProgress downloadProgress, boolean bl) throws JNLPException, IOException {
        if (jARDescArray == null) {
            return;
        }
        if (Globals.TraceDownload) {
            Debug.println("Contacting server for JAR file sizes");
        }
        long l = 0L;
        for (int i = 0; i < jARDescArray.length && l != -1L; ++i) {
            try {
                JARDesc jARDesc = jARDescArray[i];
                int n = jARDesc.isNativeLib() ? 1 : 0;
                long l2 = jARDesc.getSize();
                if (l2 == 0L) {
                    l2 = DownloadProtocol.getDownloadSize(jARDescArray[i].getLocation(), jARDescArray[i].getVersion(), n);
                }
                if (Globals.TraceDownload) {
                    Debug.println("Size of " + jARDescArray[i].getLocation() + ": " + l2);
                }
                if (l2 == -1L) {
                    l = -1L;
                    continue;
                }
                l += l2;
                continue;
            }
            catch (JNLPException jNLPException) {
                if (downloadProgress != null) {
                    downloadProgress.downloadFailed(jARDescArray[i].getLocation(), jARDescArray[i].getVersion());
                }
                throw jNLPException;
            }
        }
        if (Globals.TraceDownload) {
            Debug.println("Total size to download: " + l);
        }
        if (l == 0L) {
            return;
        }
        DownloadCallbackHelper downloadCallbackHelper = new DownloadCallbackHelper(downloadProgress, l);
        for (int i = 0; i < jARDescArray.length; ++i) {
            JARDesc jARDesc = jARDescArray[i];
            try {
                int n = jARDesc.isNativeLib() ? 1 : 0;
                DiskCacheEntry diskCacheEntry = DownloadProtocol.getResource(jARDescArray[i].getLocation(), jARDescArray[i].getVersion(), n, bl, downloadCallbackHelper);
                if (Globals.TraceDownload) {
                    System.out.println("Downloaded " + jARDescArray[i].getLocation() + ": " + diskCacheEntry);
                }
                if (diskCacheEntry != null) continue;
                throw new FailedDownloadingResourceException(null, jARDescArray[i].getLocation(), jARDescArray[i].getVersion(), null);
            }
            catch (JNLPException jNLPException) {
                if (downloadProgress != null) {
                    downloadProgress.downloadFailed(jARDesc.getLocation(), jARDesc.getVersion());
                }
                throw jNLPException;
            }
        }
    }

    public static void downloadEagerorAll(LaunchDesc launchDesc, boolean bl, DownloadProgress downloadProgress, boolean bl2) throws IOException, JNLPException {
        JARDesc[] jARDescArray;
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        JARDesc[] jARDescArray2 = resourcesDesc.getEagerOrAllJarDescs(bl);
        if (!bl && (jARDescArray = resourcesDesc.getEagerOrAllJarDescs(true)).length != jARDescArray2.length) {
            HashSet<JARDesc> hashSet = new HashSet<JARDesc>(Arrays.asList(jARDescArray2));
            int n = 0;
            for (int i = 0; i < jARDescArray.length; ++i) {
                int n2;
                URL uRL = jARDescArray[i].getLocation();
                String string = jARDescArray[i].getVersion();
                int n3 = n2 = jARDescArray[i].isJavaFile() ? 0 : 1;
                if (!hashSet.contains(jARDescArray[i]) && DownloadProtocol.isInCache(uRL, string, n2)) {
                    ++n;
                    continue;
                }
                jARDescArray[i] = null;
            }
            if (n > 0) {
                JARDesc[] jARDescArray3 = new JARDesc[jARDescArray2.length + n];
                System.arraycopy(jARDescArray2, 0, jARDescArray3, 0, jARDescArray2.length);
                int n4 = jARDescArray2.length;
                for (int i = 0; i < jARDescArray.length; ++i) {
                    if (jARDescArray[i] == null) continue;
                    jARDescArray3[n4++] = jARDescArray[i];
                }
                jARDescArray2 = jARDescArray3;
            }
        }
        LaunchDownload.downloadJarFiles(jARDescArray2, downloadProgress, bl2);
    }

    static LaunchDesc getLaunchDescFromCache(LaunchDesc launchDesc) {
        if (launchDesc.getLocation() == null) {
            return launchDesc;
        }
        try {
            DiskCacheEntry diskCacheEntry = DownloadProtocol.getCachedLaunchedFile(launchDesc.getLocation());
            if (diskCacheEntry == null) {
                return launchDesc;
            }
            if (Globals.TraceStartup) {
                Debug.println("Loaded descriptor from cache at: " + launchDesc.getLocation());
            }
            return LaunchDescFactory.buildDescriptor(diskCacheEntry.getFile());
        }
        catch (JNLPException jNLPException) {
            Debug.ignoredException(jNLPException);
        }
        catch (IOException iOException) {
            Debug.ignoredException(iOException);
        }
        return launchDesc;
    }

    static LaunchDesc getUpdatedLaunchDesc(LaunchDesc launchDesc) throws JNLPException, IOException {
        if (launchDesc.getLocation() == null) {
            return null;
        }
        boolean bl = DownloadProtocol.isLaunchFileUpdateAvailable(launchDesc.getLocation());
        if (!bl) {
            return null;
        }
        if (Globals.TraceStartup) {
            Debug.println("Downloading updated JNLP descriptor from: " + launchDesc.getLocation());
        }
        DiskCacheEntry diskCacheEntry = DownloadProtocol.getLaunchFile(launchDesc.getLocation(), false);
        return LaunchDescFactory.buildDescriptor(diskCacheEntry.getFile());
    }

    static void access$100(ArrayList arrayList, LaunchDesc launchDesc) {
        LaunchDownload.addExtensions(arrayList, launchDesc);
    }

    private static void addExtensions(ArrayList arrayList, LaunchDesc launchDesc) {
        arrayList.add(launchDesc);
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc != null) {
            resourcesDesc.visit(new ResourceVisitor(arrayList){
                private final ArrayList val$list;

                public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                    if (!extensionDesc.isInstaller()) {
                        LaunchDownload.access$100(this.val$list, extensionDesc.getExtensionDesc());
                    }
                }

                public void visitJARDesc(JARDesc jARDesc) {
                }

                public void visitJREDesc(JREDesc jREDesc) {
                }

                public void visitPackageDesc(PackageDesc packageDesc) {
                }

                public void visitPropertyDesc(PropertyDesc propertyDesc) {
                }
                {
                    this.val$list = arrayList;
                }
            });
        }
    }

    public static File[] getNativeDirectories(LaunchDesc launchDesc) {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return new File[0];
        }
        JARDesc[] jARDescArray = resourcesDesc.getEagerOrAllJarDescs(true);
        ArrayList<File> arrayList = new ArrayList<File>();
        for (int i = 0; i < jARDescArray.length; ++i) {
            String string;
            URL uRL;
            DiskCacheEntry diskCacheEntry;
            if (!jARDescArray[i].isNativeLib() || (diskCacheEntry = DownloadProtocol.getCachedVersion(uRL = jARDescArray[i].getLocation(), string = jARDescArray[i].getVersion(), 1)) == null) continue;
            arrayList.add(diskCacheEntry.getDirectory());
        }
        File[] fileArray = new File[arrayList.size()];
        return arrayList.toArray(fileArray);
    }

    static void access$000(LaunchDesc launchDesc, String string, boolean[] blArray, boolean[] blArray2) {
        LaunchDownload.checkJNLPSecurityHelper(launchDesc, string, blArray, blArray2);
    }

    private static void checkJNLPSecurityHelper(LaunchDesc launchDesc, String string, boolean[] blArray, boolean[] blArray2) {
        if (launchDesc.getSecurityModel() != 0) {
            return;
        }
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        resourcesDesc.visit(new ResourceVisitor(blArray, string, blArray2){
            private final boolean[] val$hostViolation;
            private final String val$host;
            private final boolean[] val$nativeLibViolation;

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                LaunchDesc launchDesc;
                if (!this.val$hostViolation[0] && !this.val$nativeLibViolation[0] && (launchDesc = extensionDesc.getExtensionDesc()) != null && launchDesc.getSecurityModel() == 0) {
                    String string = extensionDesc.getLocation().getHost();
                    boolean bl = this.val$hostViolation[0] = this.val$hostViolation[0] || !this.val$host.equals(string);
                    if (!this.val$hostViolation[0]) {
                        LaunchDownload.access$000(launchDesc, this.val$host, this.val$hostViolation, this.val$nativeLibViolation);
                    }
                }
            }

            public void visitJARDesc(JARDesc jARDesc) {
                String string = jARDesc.getLocation().getHost();
                this.val$hostViolation[0] = this.val$hostViolation[0] || !this.val$host.equals(string);
                this.val$nativeLibViolation[0] = this.val$nativeLibViolation[0] || jARDesc.isNativeLib();
            }

            public void visitJREDesc(JREDesc jREDesc) {
            }

            public void visitPackageDesc(PackageDesc packageDesc) {
            }

            public void visitPropertyDesc(PropertyDesc propertyDesc) {
            }
            {
                this.val$hostViolation = blArray;
                this.val$host = string;
                this.val$nativeLibViolation = blArray2;
            }
        });
    }

    static String getMainClassName(LaunchDesc launchDesc, boolean bl) throws IOException, JNLPException, LaunchDescException {
        Object object;
        AppletDesc appletDesc;
        InstallerDesc installerDesc;
        String string = null;
        ApplicationDesc applicationDesc = launchDesc.getApplicationDescriptor();
        if (applicationDesc != null) {
            string = applicationDesc.getMainClass();
        }
        if ((installerDesc = launchDesc.getInstallerDescriptor()) != null) {
            string = installerDesc.getMainClass();
        }
        if ((appletDesc = launchDesc.getAppletDescriptor()) != null) {
            string = appletDesc.getAppletClass();
        }
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (launchDesc.getResources() == null) {
            return null;
        }
        JARDesc jARDesc = launchDesc.getResources().getMainJar(bl);
        if (jARDesc == null) {
            return null;
        }
        DiskCacheEntry diskCacheEntry = DownloadProtocol.getResource(jARDesc.getLocation(), jARDesc.getVersion(), 0, true, null);
        JarFile jarFile = new JarFile(diskCacheEntry.getFile());
        if (string == null && launchDesc.getLaunchType() != 2) {
            object = jarFile.getManifest();
            String string2 = string = object != null ? ((Manifest)object).getMainAttributes().getValue("Main-Class") : null;
        }
        if (string == null) {
            throw new LaunchDescException(launchDesc, Resources.getString("launch.error.nomainclassspec"), null);
        }
        object = string.replace('.', '/') + ".class";
        if (jarFile.getEntry((String)object) == null) {
            throw new LaunchDescException(launchDesc, Resources.getString("launch.error.nomainclass", string, jARDesc.getLocation().toString()), null);
        }
        return string;
    }

    public static void downloadParts(LaunchDesc launchDesc, String[] stringArray, DownloadProgress downloadProgress, boolean bl) throws IOException, JNLPException {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        JARDesc[] jARDescArray = resourcesDesc.getPartJars(stringArray);
        LaunchDownload.downloadJarFiles(jARDescArray, downloadProgress, bl);
    }

    static void downloadExtensions(LaunchDesc launchDesc, DownloadProgress downloadProgress, int n, ArrayList arrayList) throws IOException, JNLPException {
        LaunchDownload.downloadExtensionsHelper(launchDesc, downloadProgress, n, false, arrayList);
    }

    private static boolean downloadExtensionsHelper(LaunchDesc launchDesc, DownloadProgress downloadProgress, int n, boolean bl, ArrayList arrayList) throws IOException, JNLPException {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return true;
        }
        String string = ConfigProperties.getInstance().getKnownPlatforms();
        ArrayList arrayList2 = new ArrayList();
        resourcesDesc.visit(new ResourceVisitor(arrayList2){
            private final ArrayList val$list;

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                this.val$list.add(extensionDesc);
            }

            public void visitJARDesc(JARDesc jARDesc) {
            }

            public void visitJREDesc(JREDesc jREDesc) {
            }

            public void visitPackageDesc(PackageDesc packageDesc) {
            }

            public void visitPropertyDesc(PropertyDesc propertyDesc) {
            }
            {
                this.val$list = arrayList;
            }
        });
        n += arrayList2.size();
        for (int i = 0; i < arrayList2.size(); ++i) {
            int n2;
            ExtensionDesc extensionDesc = (ExtensionDesc)arrayList2.get(i);
            String string2 = extensionDesc.getName();
            if (string2 == null && (n2 = (string2 = extensionDesc.getLocation().toString()).lastIndexOf(47)) > 0) {
                string2 = string2.substring(n2 + 1, string2.length());
            }
            --n;
            if (downloadProgress != null) {
                downloadProgress.extensionDownload(string2, n);
            }
            DiskCacheEntry diskCacheEntry = null;
            if (!bl) {
                diskCacheEntry = DownloadProtocol.getExtension(extensionDesc.getLocation(), extensionDesc.getVersion(), string, false);
            } else {
                diskCacheEntry = DownloadProtocol.getCachedExtension(extensionDesc.getLocation(), extensionDesc.getVersion(), string);
                if (diskCacheEntry == null) {
                    return false;
                }
            }
            if (Globals.TraceDownload) {
                System.out.println("Downloaded extension: " + extensionDesc.getLocation() + ": " + diskCacheEntry.getFile());
            }
            LaunchDesc launchDesc2 = LaunchDescFactory.buildDescriptor(diskCacheEntry.getFile());
            boolean bl2 = false;
            if (launchDesc2.getLaunchType() == 3) {
                bl2 = true;
            } else if (launchDesc2.getLaunchType() == 4) {
                extensionDesc.setInstaller(true);
                LocalApplicationProperties localApplicationProperties = InstallCache.getCache().getLocalApplicationProperties(diskCacheEntry.getLocation(), diskCacheEntry.getVersionId(), launchDesc, false);
                boolean bl3 = bl2 = !localApplicationProperties.isLocallyInstalled();
                if (arrayList != null && (LaunchDownload.isUpdateAvailable(launchDesc2) || bl2)) {
                    arrayList.add(diskCacheEntry.getFile());
                }
                if (bl && bl2) {
                    return false;
                }
            } else {
                throw new MissingFieldException(launchDesc2.getSource(), "<component-desc>|<installer-desc>");
            }
            if (!bl2) continue;
            extensionDesc.setExtensionDesc(launchDesc2);
            boolean bl4 = LaunchDownload.downloadExtensionsHelper(launchDesc2, downloadProgress, n, bl, arrayList);
            if (bl4) continue;
            return false;
        }
        return true;
    }

    public static void downloadJRE(LaunchDesc launchDesc, DownloadProgress downloadProgress, ArrayList arrayList) throws JNLPException, IOException {
        boolean bl;
        JREDesc jREDesc = launchDesc.getResources().getSelectedJRE();
        String string = jREDesc.getVersion();
        URL uRL = jREDesc.getHref();
        boolean bl2 = bl = uRL == null;
        if (uRL == null) {
            uRL = ConfigProperties.getInstance().getJREInstallURL();
        }
        if (downloadProgress != null) {
            downloadProgress.jreDownload(string, uRL);
        }
        String string2 = ConfigProperties.getInstance().getKnownPlatforms();
        DiskCacheEntry diskCacheEntry = null;
        try {
            diskCacheEntry = DownloadProtocol.getJRE(uRL, string, bl, string2);
        }
        catch (ErrorCodeResponseException errorCodeResponseException) {
            errorCodeResponseException.setJreDownload(true);
            throw errorCodeResponseException;
        }
        LaunchDesc launchDesc2 = LaunchDescFactory.buildDescriptor(diskCacheEntry.getFile());
        if (launchDesc2.getLaunchType() != 4) {
            throw new MissingFieldException(launchDesc2.getSource(), "<installer-desc>");
        }
        if (arrayList != null) {
            arrayList.add(diskCacheEntry.getFile());
        }
        jREDesc.setExtensionDesc(launchDesc2);
        LaunchDownload.downloadExtensionsHelper(launchDesc2, downloadProgress, 0, false, arrayList);
    }

    public static void downloadResource(LaunchDesc launchDesc, URL uRL, String string, DownloadProgress downloadProgress, boolean bl) throws IOException, JNLPException {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        JARDesc[] jARDescArray = resourcesDesc.getResource(uRL, string);
        LaunchDownload.downloadJarFiles(jARDescArray, downloadProgress, bl);
    }

    public static void downloadExtensionPart(LaunchDesc launchDesc, URL uRL, String string, String[] stringArray, DownloadProgress downloadProgress, boolean bl) throws IOException, JNLPException {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        JARDesc[] jARDescArray = resourcesDesc.getExtensionPart(uRL, string, stringArray);
        LaunchDownload.downloadJarFiles(jARDescArray, downloadProgress, bl);
    }

    private static class DownloadCallbackHelper
    implements DownloadProtocol.DownloadDelegate {
        DownloadProgress _downloadProgress;
        long _totalSize;
        long _downloadedSoFar;
        long _currentTotal;

        private int getPercent(double d) {
            if (d > (double)this._totalSize) {
                this._totalSize = -1L;
                return -1;
            }
            double d2 = d * 100.0 / (double)this._totalSize;
            return (int)(d2 + 0.5);
        }

        public DownloadCallbackHelper(DownloadProgress downloadProgress, long l) {
            this._downloadProgress = downloadProgress;
            this._totalSize = l;
            this._downloadedSoFar = 0L;
        }

        public void validating(URL uRL, int n, int n2) {
            int n3 = -1;
            if (this._totalSize != -1L && n2 != 0) {
                double d = (double)this._downloadedSoFar + 0.9 * (double)this._currentTotal + 0.1 * (double)this._currentTotal * ((double)n / (double)n2);
                n3 = this.getPercent(d);
            }
            if (this._downloadProgress != null) {
                this._downloadProgress.validating(uRL, null, n, n2, n3);
            }
            if (n == n2) {
                this._downloadedSoFar += this._currentTotal;
            }
        }

        public void downloadFailed(URL uRL, String string) {
            if (this._downloadProgress != null) {
                this._downloadProgress.downloadFailed(uRL, string);
            }
        }

        public void patching(URL uRL, String string, int n) {
            int n2 = -1;
            if (this._totalSize != -1L) {
                double d = (double)this._downloadedSoFar + (double)this._currentTotal * (0.8 + (double)n / 1000.0);
                n2 = this.getPercent(d);
            }
            if (this._downloadProgress != null) {
                this._downloadProgress.patching(uRL, string, n, n2);
            }
        }

        public void downloading(URL uRL, String string, int n, int n2, boolean bl) {
            int n3 = -1;
            if (this._totalSize != -1L) {
                double d = bl ? 0.8 : 0.9;
                double d2 = (double)this._downloadedSoFar + d * (double)n;
                n3 = this.getPercent(d2);
                this._currentTotal = n2;
            }
            if (this._downloadProgress != null) {
                this._downloadProgress.progress(uRL, string, this._downloadedSoFar + (long)n, this._totalSize, n3);
            }
        }
    }

    public static interface DownloadProgress {
        public void extensionDownload(String var1, int var2);

        public void downloadFailed(URL var1, String var2);

        public void patching(URL var1, String var2, int var3, int var4);

        public void progress(URL var1, String var2, long var3, long var5, int var7);

        public void validating(URL var1, String var2, long var3, long var5, int var7);

        public void jreDownload(String var1, URL var2);
    }
}

